/*
 * Decompiled with CFR 0.152.
 */
package com.gears42.zebra;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class SendFileToPrinter {
    public static void main(String[] args) {
        block21: {
            try {
                block22: {
                    TcpConnection conn;
                    block23: {
                        if (args.length <= 0) break block22;
                        Scanner sc = new Scanner(System.in);
                        boolean isConnected = false;
                        boolean isExit = false;
                        conn = new TcpConnection(args[0], 9100);
                        conn.open();
                        if (conn.isConnected()) {
                            isConnected = true;
                            System.out.println("Status : Printer connected");
                        } else {
                            System.out.println("Status : Printer Disconnected");
                            System.out.println("Please Check IP Of Printer...");
                        }
                        if (!isConnected) break block23;
                        block12: while (!isExit) {
                            System.out.println("1: Transfer File to Printer");
                            System.out.println("2: Send Command file to Printer");
                            System.out.println("3: Exit");
                            System.out.println("------------------------------");
                            System.out.println("Enter your Action");
                            String action = sc.nextLine();
                            String filePath = "";
                            switch (action) {
                                case "1": {
                                    System.out.println("Enter filePath :");
                                    filePath = sc.nextLine();
                                    if (!SendFileToPrinter.isNullOrEmpty(filePath)) {
                                        SendFileToPrinter.sendFiletoPrinter(conn, filePath);
                                        continue block12;
                                    }
                                    System.out.println("filePath is null");
                                    continue block12;
                                }
                                case "2": {
                                    System.out.println("Enter filePath :");
                                    filePath = sc.nextLine();
                                    if (!SendFileToPrinter.isNullOrEmpty(filePath)) {
                                        SendFileToPrinter.sendCommandsToPrinter(conn, filePath);
                                        continue block12;
                                    }
                                    System.out.println("filePath is null");
                                    continue block12;
                                }
                                case "3": {
                                    isExit = true;
                                    continue block12;
                                }
                            }
                            System.out.println("Please Select 1,2 or 3...");
                        }
                    }
                    if (conn.isConnected()) {
                        conn.close();
                    }
                    break block21;
                }
                System.out.println("Please Provide Printer IP");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void sendFiletoPrinter(Connection conn, String filePath) {
        try {
            ZebraPrinterLinkOs linkOs = ZebraPrinterFactory.getLinkOsPrinter(conn);
            File file = new File(filePath);
            String filename = "E:" + file.getName();
            linkOs.storeFileOnPrinter(file.getAbsolutePath(), filename);
            System.out.println(String.valueOf(file.getName()) + " sent successfully");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static void sendCommandsToPrinter(Connection conn, String filePath) {
        try {
            String cmds = SendFileToPrinter.readFromFile(filePath);
            conn.write(new ByteArrayInputStream(cmds.getBytes(StandardCharsets.UTF_8)));
            System.out.println("Commands Sent Succesfully");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static String readFromFile(String filePath) {
        String data = "";
        try {
            int i;
            FileReader fr = new FileReader(filePath);
            while ((i = fr.read()) != -1) {
                data = String.valueOf(data) + (char)i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static boolean isNullOrEmpty(String strValue) {
        return strValue == null || strValue.equals("") || strValue.trim().length() == 0 || strValue.trim().equalsIgnoreCase("?");
    }
}

