/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.certificate.internal;

import com.zebra.sdk.certificate.ZebraCertificateException;
import com.zebra.sdk.certificate.internal.CertUtilitiesI;
import com.zebra.sdk.util.internal.CertificateInfo;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.crypto.prng.ThreadedSeedGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemWriter;

public class CertUtilities
implements CertUtilitiesI {
    protected static final ASN1ObjectIdentifier PRIVATE_KEY_CMS_ALGO = CMSAlgorithm.AES128_CBC;
    protected static final String ZEBRA_PKCS12_KEY_ALIAS = "zebra_linkos";
    protected static final String PEM_HEADER = "-----BEGIN ";
    protected static final String PEM_FOOTER = "-----END ";
    protected static final String PEM_END_CERTIFICATE = "-----END CERTIFICATE-----";
    protected static final String PEM_BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    protected static final String PEM_END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    protected static final String PEM_BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";

    @Override
    public void getPrivateKeyFromPkcs12Keystore(String string, String string2, String string3, OutputStream outputStream, KeyStore keyStore) throws UnrecoverableKeyException, IOException, ZebraCertificateException {
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("A private key passphrase must be supplied");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("A p12 keystore passphrase must be supplied");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("An alias must be supplied");
        }
        if (keyStore == null) {
            throw new IllegalArgumentException("A keystore must be supplied");
        }
        Security.addProvider(new BouncyCastleProvider());
        PrivateKey privateKey = this.getPrivateKey(string, string2, keyStore);
        this.savePrivateKey(privateKey, new OutputStreamWriter(outputStream), string3);
    }

    @Override
    public void getCaFromPkcs12Keystore(String string, OutputStream outputStream, KeyStore keyStore) throws IOException, ZebraCertificateException {
        if (keyStore == null) {
            throw new IllegalArgumentException("A keystore must be supplied");
        }
        Security.addProvider(new BouncyCastleProvider());
        Certificate[] certificateArray = this.getCertificateChain(string, keyStore);
        String string2 = "";
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        try {
            for (int i = 1; i < certificateArray.length; ++i) {
                byte[] byArray = certificateArray[i].getEncoded();
                string2 = this.convertDerCertToPemCert(byArray);
                outputStreamWriter.write(string2 + "\r\n");
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new ZebraCertificateException("Failed to encode the certificate provided in the p12 file.", certificateEncodingException);
        }
        finally {
            outputStreamWriter.close();
        }
    }

    @Override
    public Certificate[] getCertificateChain(String string, KeyStore keyStore) throws ZebraCertificateException {
        Certificate[] certificateArray = null;
        try {
            certificateArray = keyStore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ZebraCertificateException("The p12 file was not valid.", keyStoreException);
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new ZebraCertificateException("Error: Could not locate the certificate within the provided PKCS12 file. Make sure the alias used is valid.");
        }
        return certificateArray;
    }

    @Override
    public PrivateKey getPrivateKey(String string, String string2, KeyStore keyStore) throws UnrecoverableKeyException {
        Security.addProvider(new BouncyCastleProvider());
        Key key = null;
        try {
            key = keyStore.getKey(string, string2.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            throw new UnrecoverableKeyException("Could not recover the private key from the pkcs12 file. Verify that the provided passkey is correct and any provided aliases are valid.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnrecoverableKeyException("Could not recover the private key from the pkcs12 file. The key algorithm may not be supported: " + noSuchAlgorithmException.getLocalizedMessage());
        }
        if (!(key instanceof PrivateKey)) {
            throw new UnrecoverableKeyException("Could not recover the private key from the pkcs12 file. Verify that the provided passkey is correct and any provided aliases are valid.");
        }
        return (PrivateKey)key;
    }

    @Override
    public void getCertificateFromPkcs12Keystore(String string, OutputStream outputStream, KeyStore keyStore) throws ZebraCertificateException, IOException {
        Security.addProvider(new BouncyCastleProvider());
        Certificate[] certificateArray = this.getCertificateChain(string, keyStore);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        try {
            byte[] byArray = certificateArray[0].getEncoded();
            String string2 = this.convertDerCertToPemCert(byArray);
            outputStreamWriter.write(string2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new ZebraCertificateException("Failed to encode the certificate provided in the p12 file.", certificateEncodingException);
        }
        finally {
            outputStreamWriter.close();
        }
    }

    protected void savePrivateKey(PrivateKey privateKey, Writer writer, String string) {
        try {
            PemWriter pemWriter = new PemWriter(writer);
            JceOpenSSLPKCS8EncryptorBuilder jceOpenSSLPKCS8EncryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PRIVATE_KEY_CMS_ALGO);
            jceOpenSSLPKCS8EncryptorBuilder.setProvider(BouncyCastleProvider.PROVIDER_NAME);
            ThreadedSeedGenerator threadedSeedGenerator = new ThreadedSeedGenerator();
            jceOpenSSLPKCS8EncryptorBuilder.setRandom(new SecureRandom(threadedSeedGenerator.generateSeed(20, true)));
            jceOpenSSLPKCS8EncryptorBuilder.setPasssword(string.toCharArray());
            OutputEncryptor outputEncryptor = jceOpenSSLPKCS8EncryptorBuilder.build();
            JcaPKCS8Generator jcaPKCS8Generator = new JcaPKCS8Generator(privateKey, outputEncryptor);
            PemObject pemObject = jcaPKCS8Generator.generate();
            pemWriter.writeObject(pemObject);
            pemWriter.close();
        }
        catch (PemGenerationException pemGenerationException) {
        }
        catch (IOException iOException) {
        }
        catch (OperatorCreationException operatorCreationException) {
            // empty catch block
        }
    }

    @Override
    public String convertDerKeyToPemKey(byte[] byArray) throws ZebraCertificateException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----BEGIN PRIVATE KEY-----\r\n");
        stringBuffer.append(this.convertDerToPem(byArray));
        stringBuffer.append("-----END PRIVATE KEY-----\r\n");
        return stringBuffer.toString();
    }

    @Override
    public String convertDerCertToPemCert(byte[] byArray) throws ZebraCertificateException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----BEGIN CERTIFICATE-----\r\n");
        stringBuffer.append(this.convertDerToPem(byArray));
        stringBuffer.append("-----END CERTIFICATE-----\r\n");
        return stringBuffer.toString();
    }

    private String convertDerToPem(byte[] byArray) throws ZebraCertificateException {
        if (byArray == null || byArray.length == 0) {
            throw new ZebraCertificateException("The DER contents must be provided");
        }
        Base64 base64 = new Base64(64, new byte[]{13, 10});
        byte[] byArray2 = base64.encode(byArray);
        return new String(byArray2);
    }

    public PrivateKeyInfo getKeyFile(String string, String string2) {
        Security.addProvider(new BouncyCastleProvider());
        PrivateKeyInfo privateKeyInfo = null;
        try {
            PEMParser pEMParser = new PEMParser(new StringReader(string));
            Object object = pEMParser.readObject();
            if (object instanceof PEMKeyPair) {
                privateKeyInfo = ((PEMKeyPair)pEMParser.readObject()).getPrivateKeyInfo();
            } else if (object instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)object;
            } else if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair pEMEncryptedKeyPair = (PEMEncryptedKeyPair)object;
                JcePEMDecryptorProviderBuilder jcePEMDecryptorProviderBuilder = new JcePEMDecryptorProviderBuilder();
                jcePEMDecryptorProviderBuilder.setProvider(BouncyCastleProvider.PROVIDER_NAME);
                PEMDecryptorProvider pEMDecryptorProvider = jcePEMDecryptorProviderBuilder.build(string2.toCharArray());
                PEMKeyPair pEMKeyPair = pEMEncryptedKeyPair.decryptKeyPair(pEMDecryptorProvider);
                if (pEMKeyPair != null) {
                    privateKeyInfo = pEMKeyPair.getPrivateKeyInfo();
                }
            } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo pKCS8EncryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object;
                JceOpenSSLPKCS8DecryptorProviderBuilder jceOpenSSLPKCS8DecryptorProviderBuilder = new JceOpenSSLPKCS8DecryptorProviderBuilder();
                jceOpenSSLPKCS8DecryptorProviderBuilder.setProvider(BouncyCastleProvider.PROVIDER_NAME);
                privateKeyInfo = pKCS8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(jceOpenSSLPKCS8DecryptorProviderBuilder.build(string2.toCharArray()));
            }
            pEMParser.close();
        }
        catch (IOException iOException) {
        }
        catch (OperatorCreationException operatorCreationException) {
        }
        catch (PKCSException pKCSException) {
            // empty catch block
        }
        return privateKeyInfo;
    }

    public PrivateKeyInfo getKeyFileFromStream(InputStream inputStream, String string) {
        try {
            String string2 = IOUtils.toString(inputStream);
            return this.getKeyFile(string2, string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public KeyPair getKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.addProvider(new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", BouncyCastleProvider.PROVIDER_NAME);
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    @Override
    public void save(CertificateInfo certificateInfo, KeyPair keyPair, String string, String string2, String string3, int n, String string4, String string5, String string6) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (certificateInfo == null || keyPair == null || string == null || string.isEmpty() || string2 == null || string2.isEmpty() || string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("All parameters must be supplied in order to save the p12 fill successfully");
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        String string7 = certificateInfo.getUserRequestInfo().getCommonName();
        String string8 = string + string7 + ".cer";
        String string9 = string + string7 + ".csr";
        String string10 = string + string7 + ".p12";
        String string11 = string + string7 + ".key";
        Writer writer = this.getWriter(string11);
        this.savePrivateKey(keyPair.getPrivate(), writer, string3);
        writer = this.getWriter(string8);
        writer.write(certificateInfo.getCertificate());
        writer.close();
        writer = this.getWriter(string9);
        writer.write(certificateInfo.getUserRequestInfo().getCsr());
        writer.close();
        this.createP12File(keyPair.getPrivate(), this.createCertChain(certificateInfo.getCertificate()), string10, string2);
    }

    protected Writer getWriter(String string) throws IOException {
        return new FileWriter(string);
    }

    protected OutputStream getOutputStream(String string) throws FileNotFoundException {
        return new FileOutputStream(string);
    }

    @Override
    public Certificate[] createCertChain(String string) throws IOException, CertificateException {
        Security.addProvider(new BouncyCastleProvider());
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("certificates/ZebraCAChain.cer");
        PEMParser pEMParser = new PEMParser(new InputStreamReader(inputStream));
        PEMParser pEMParser2 = new PEMParser(new StringReader(string));
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)pEMParser2.readObject();
        X509CertificateHolder x509CertificateHolder2 = (X509CertificateHolder)pEMParser.readObject();
        X509CertificateHolder x509CertificateHolder3 = (X509CertificateHolder)pEMParser.readObject();
        pEMParser2.close();
        pEMParser.close();
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter().setProvider(BouncyCastleProvider.PROVIDER_NAME);
        X509CertificateObject x509CertificateObject = (X509CertificateObject)jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
        X509CertificateObject x509CertificateObject2 = (X509CertificateObject)jcaX509CertificateConverter.getCertificate(x509CertificateHolder2);
        X509CertificateObject x509CertificateObject3 = (X509CertificateObject)jcaX509CertificateConverter.getCertificate(x509CertificateHolder3);
        Certificate[] certificateArray = new X509Certificate[]{x509CertificateObject, x509CertificateObject2, x509CertificateObject3};
        return certificateArray;
    }

    @Override
    public void createP12File(PrivateKey privateKey, Certificate[] certificateArray, String string, String string2) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry(ZEBRA_PKCS12_KEY_ALIAS, privateKey, string2.toCharArray(), certificateArray);
        keyStore.store(this.getOutputStream(string), string2.toCharArray());
    }

    @Override
    public Certificate getCertificate(String string) {
        Security.addProvider(new BouncyCastleProvider());
        Certificate certificate = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
            certificate = certificateFactory.generateCertificate(IOUtils.toInputStream(string));
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return certificate;
    }
}

