/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.certificate.internal;

import com.zebra.sdk.certificate.internal.CertificateHelperI;
import java.io.IOException;
import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;

public class CertificateHelper
implements CertificateHelperI {
    @Override
    public void pemWriterHelper(PrivateKey privateKey, StringWriter stringWriter) throws IOException {
        PEMWriter pEMWriter = new PEMWriter(stringWriter);
        pEMWriter.writeObject(privateKey);
        pEMWriter.close();
    }

    @Override
    public void pemWriterHelper(Certificate certificate, StringWriter stringWriter) throws IOException {
        PEMWriter pEMWriter = new PEMWriter(stringWriter);
        pEMWriter.writeObject(certificate);
        pEMWriter.close();
    }

    @Override
    public Provider getCertificateProvider() throws CertificateException {
        return new BouncyCastleProvider();
    }

    @Override
    public String getCommonNameHelper(X509Certificate x509Certificate) throws CertificateEncodingException {
        X500Name x500Name = new JcaX509CertificateHolder(x509Certificate).getSubject();
        RDN rDN = x500Name.getRDNs(BCStyle.CN)[0];
        String string = IETFUtils.valueToString(rDN.getFirst().getValue());
        return string;
    }
}

