/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.snmp.internal;

import com.zebra.sdk.comm.snmp.internal.OidNotFoundException;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.varbind;

public abstract class SnmpV1
implements Observer {
    public static int port = 161;
    private String host;
    private varbind var;
    private String socketType = "Standard";
    private SnmpContext context;
    private Pdu pdu;
    private boolean pduInFlight;
    public static final int[] default_retry_interval = new int[]{500, 1000, 2000, 5000, 5000};
    protected int maxRetries;

    public SnmpV1(String string) throws IOException {
        this(string, "public", 5);
    }

    public SnmpV1(String string, String string2, int n) throws IOException {
        this.host = string;
        this.maxRetries = n;
        this.setupSnmpContext(string2);
    }

    @Override
    public void update(Observable observable, Object object) {
        int n = ((Pdu)observable).getErrorStatus();
        this.var = n == 0 ? (varbind)object : null;
    }

    public Object getReturnValue() throws OidNotFoundException {
        if (this.var != null) {
            return this.var.getValue();
        }
        throw new OidNotFoundException();
    }

    protected void setupSnmpContext(String string) throws IOException {
        this.context = new SnmpContext(this.host, port, this.socketType);
        this.context.setCommunity(string);
    }

    public void sendRequest() {
        boolean bl = false;
        if (!this.pduInFlight) {
            this.pduInFlight = true;
            this.pdu.addObserver(this);
            try {
                this.pdu.send();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (PduException pduException) {
                pduException.printStackTrace();
            }
        }
        if (bl) {
            this.pduInFlight = false;
        }
    }

    public Pdu getPdu() {
        return this.pdu;
    }

    public void setPdu(Pdu pdu) {
        this.pdu = pdu;
    }

    public static boolean isWellFormedOid(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null oid");
        }
        try {
            new AsnObjectId(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad oid: [" + string + "]");
        }
        return true;
    }

    public static int[] formTimeOut(int n, int n2) {
        int[] nArray = null;
        if (n2 <= 0 || n <= 0) {
            return default_retry_interval;
        }
        nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n * 1000 / n2 * (i + 1);
        }
        return nArray;
    }

    public SnmpContext getContext() {
        return this.context;
    }

    public void setContext(SnmpContext snmpContext) {
        this.context = snmpContext;
    }

    public void setPduInFlight(boolean bl) {
        this.pduInFlight = bl;
    }

    public void destroy() {
        this.getContext().destroy();
    }

    public Object getReturnOid() throws OidNotFoundException {
        if (this.var != null) {
            return this.var.getOid().getValue();
        }
        throw new OidNotFoundException();
    }
}

