/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import au.com.bytecode.opencsv.CSVReader;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.internal.ConnectionBuilderInternal;
import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.internal.CsvPrinterHelper;
import com.zebra.sdk.printer.internal.FormatUtilZpl;
import com.zebra.sdk.printer.internal.TemplateInfo;
import com.zebra.sdk.printer.internal.UnicodeReader;
import com.zebra.sdk.printer.internal.UseDefaultMappingException;
import com.zebra.sdk.printer.internal.VerbosePrinter;
import com.zebra.sdk.util.internal.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvPrinter {
    private CsvPrinter() {
    }

    public static void print(InputStream inputStream, String string, String string2, OutputStream outputStream) throws IOException, ConnectionException {
        CsvPrinter.print(null, inputStream, string, string2, outputStream, false);
    }

    public static void print(String string, InputStream inputStream, String string2, String string3, OutputStream outputStream) throws IOException, ConnectionException {
        CsvPrinter.print(string, inputStream, string2, string3, outputStream, false);
    }

    public static void print(InputStream inputStream, String string, String string2, OutputStream outputStream, boolean bl) throws IOException, ConnectionException {
        CsvPrinter.print(null, inputStream, string, string2, outputStream, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static void print(String string, InputStream inputStream, String string2, String string3, OutputStream outputStream, boolean bl) throws IOException, ConnectionException {
        Object object;
        int n;
        VerbosePrinter verbosePrinter = new VerbosePrinter(bl);
        verbosePrinter.println("Reading CSV data...");
        UnicodeReader unicodeReader = new UnicodeReader(inputStream, "utf8");
        CSVReader cSVReader = new CSVReader(unicodeReader);
        List<String[]> list = cSVReader.readAll();
        cSVReader.close();
        ((Reader)unicodeReader).close();
        verbosePrinter.println(String.format("CSV Data contains %d lines...", list.size()));
        for (String[] object2 : list) {
            verbosePrinter.print(String.format("This lines contains %d items...", object2.length));
            String[] stringArray = object2;
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = stringArray[i];
                verbosePrinter.print(String.format("<%s>", object));
            }
            verbosePrinter.println("");
        }
        verbosePrinter.println("...end of CSV Data");
        Object object4 = new int[1];
        object4[0] = -1;
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.acquire(string, string2);
        verbosePrinter.println("Done acquiring template");
        int[] nArray = new int[templateInfo.variableFields.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        if (templateInfo.isLocalToComputer && string != null) {
            CsvPrinter.sendStuffToPrinter(string, FileReader.toByteArray(string2));
        }
        if (CsvPrinter.csvDataIsSingleLineWithVariables(list)) {
            verbosePrinter.println("Is single line w/variables");
            Map<Integer, String> map = CsvPrinter.convertToKeyedByFieldNumber(list.get(0), templateInfo);
            verbosePrinter.println("Done convertToKeyedByFieldNumber");
            CsvPrinter.doOutput(string, string2, string3, outputStream, templateInfo, map);
            verbosePrinter.println("Printed the line of CSV");
        } else {
            verbosePrinter.println("Is not single line w/variables");
            try {
                verbosePrinter.println("Getting first line of data...");
                String[] stringArray = list.get(0);
                verbosePrinter.println("...extracted first line of data");
                int[] nArray2 = CsvPrinterHelper.extractFdsByColumnHeading(templateInfo.variableFields, stringArray, (int[])object4);
                verbosePrinter.println("Done extractFdsByColumnHeading");
                list.remove(0);
            }
            catch (UseDefaultMappingException useDefaultMappingException) {
                // empty catch block
            }
            verbosePrinter.println("Starting CSV processing...");
            for (String[] stringArray : list) {
                object = new HashMap();
                if (templateInfo.variableFields.length > stringArray.length) continue;
                for (int i = 0; i < templateInfo.variableFields.length; ++i) {
                    void var12_16;
                    object.put(templateInfo.variableFields[i].fieldNumber, stringArray[var12_16[i]]);
                }
                String string4 = object4[0] >= 0 ? stringArray[object4[0]] : string3;
                CsvPrinter.doOutput(string, string2, string4, outputStream, templateInfo, (Map<Integer, String>)object);
                verbosePrinter.println("...printed a line of CSV");
            }
            verbosePrinter.println("Done processing CSV");
        }
    }

    private static Map<Integer, String> convertToKeyedByFieldNumber(String[] stringArray, TemplateInfo templateInfo) {
        Map<String, String> map = CsvPrinterHelper.parseSingleLineFormat(stringArray);
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (String string : map.keySet()) {
            for (FieldDescriptionData fieldDescriptionData : templateInfo.variableFields) {
                if (!string.equals(fieldDescriptionData.fieldName)) continue;
                hashMap.put(fieldDescriptionData.fieldNumber, map.get(string));
            }
        }
        return hashMap;
    }

    private static void doOutput(String string, String string2, String string3, OutputStream outputStream, TemplateInfo templateInfo, Map<Integer, String> map) throws IOException, ConnectionException {
        String string4 = FormatUtilZpl.generateStoredFormat(templateInfo.pathOnPrinter, map, string3);
        if (outputStream != null) {
            outputStream.write(string4.getBytes("utf8"));
        }
        if (string != null) {
            CsvPrinter.sendStuffToPrinter(string, string4.getBytes());
        }
    }

    private static boolean csvDataIsSingleLineWithVariables(List<String[]> list) {
        return list.size() == 1 && 0 != CsvPrinterHelper.parseSingleLineFormat(list.get(0)).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendStuffToPrinter(String string, byte[] byArray) throws ConnectionException {
        Connection connection = null;
        try {
            connection = ConnectionBuilderInternal.build(string);
            connection.open();
            PrinterLanguage printerLanguage = PrinterLanguage.ZPL;
            ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.getLinkOsPrinter(connection);
            if (zebraPrinterLinkOs != null) {
                printerLanguage = zebraPrinterLinkOs.getPrinterControlLanguage();
            }
            if (CsvPrinter.isChannelInvalidForZpl(connection, printerLanguage)) {
                throw new ConnectionException("Cannot send Zpl - printer is in line mode or port is status port.");
            }
            connection.write(byArray);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static boolean isChannelInvalidForZpl(Connection connection, PrinterLanguage printerLanguage) {
        boolean bl;
        boolean bl2 = bl = CsvPrinter.hasPrintingChannel(connection) && printerLanguage == PrinterLanguage.LINE_PRINT;
        if (!bl) {
            bl = CsvPrinter.doesNotHavePrintChannel(connection);
        }
        return bl;
    }

    private static boolean hasPrintingChannel(Connection connection) {
        boolean bl = false;
        if (connection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)connection;
            bl = multichannelConnection.getPrintingChannel().isConnected();
        } else {
            bl = !(connection instanceof StatusConnection);
        }
        return bl;
    }

    private static boolean doesNotHavePrintChannel(Connection connection) {
        MultichannelConnection multichannelConnection;
        boolean bl = false;
        bl = connection instanceof MultichannelConnection ? !(multichannelConnection = (MultichannelConnection)connection).getPrintingChannel().isConnected() : connection instanceof StatusConnection;
        return bl;
    }
}

