/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.FileUtilLinkOs;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.FileDeletionOption;
import com.zebra.sdk.printer.FirmwareUpdateHandler;
import com.zebra.sdk.printer.FirmwareUpdaterLinkOs;
import com.zebra.sdk.printer.FormatUtilLinkOs;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.ProfileUtil;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.printer.TcpPortStatus;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.internal.FileUtilLinkOsImpl;
import com.zebra.sdk.printer.internal.FirmwareUpdaterLinkOsBase;
import com.zebra.sdk.printer.internal.FormatUtilLinkOsImpl;
import com.zebra.sdk.printer.internal.MultipartFormReceiverStream;
import com.zebra.sdk.printer.internal.PortStatus;
import com.zebra.sdk.printer.internal.ProfileUtilLinkOsImpl;
import com.zebra.sdk.printer.internal.ToolsUtilLinkOsHelper;
import com.zebra.sdk.printer.internal.ZebraPrinterZpl;
import com.zebra.sdk.printer.operations.internal.ConfigurationLabelPrinter;
import com.zebra.sdk.printer.operations.internal.FileStorer;
import com.zebra.sdk.printer.operations.internal.HostStatusOperation;
import com.zebra.sdk.printer.operations.internal.ImageStorer;
import com.zebra.sdk.printer.operations.internal.NetworkConfigurationLabelPrinter;
import com.zebra.sdk.printer.operations.internal.NetworkDefaulter;
import com.zebra.sdk.printer.operations.internal.NetworkResetter;
import com.zebra.sdk.printer.operations.internal.ObjectGrabberOperation;
import com.zebra.sdk.printer.operations.internal.ObjectsListingOperation;
import com.zebra.sdk.printer.operations.internal.PrinterCalibrator;
import com.zebra.sdk.printer.operations.internal.PrinterDefaulter;
import com.zebra.sdk.printer.operations.internal.PrinterResetter;
import com.zebra.sdk.printer.operations.internal.SettingsUpdaterOperation;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.AlertsUtilLinkOs;
import com.zebra.sdk.settings.internal.ZebraSettingsListFromConnection;
import com.zebra.sdk.util.fileConversion.internal.DZ_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.HzoToDzConverterStream;
import com.zebra.sdk.util.fileConversion.internal.MPF_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.util.internal.ZPLUtilities;
import com.zebra.sdk.util.internal.ZipUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;

public class ZebraPrinterLinkOsImpl
implements ZebraPrinterLinkOs {
    private ZebraPrinter genericPrinter;
    public ZebraSettingsListFromConnection settings = null;
    protected ProfileUtil profile = null;
    protected AlertsUtilLinkOs alerts = null;
    protected FileUtilLinkOs fileUtil = null;
    protected FormatUtilLinkOs formatUtil = null;
    protected ToolsUtilLinkOsHelper toolsUtilHelper = null;
    protected FirmwareUpdaterLinkOs fwDownloader = null;
    private String getCommunityName;
    private LinkOsInformation linkOsInformation;
    private PrinterLanguage language;

    public ZebraPrinterLinkOsImpl(ZebraPrinter zebraPrinter, LinkOsInformation linkOsInformation, PrinterLanguage printerLanguage) {
        this.linkOsInformation = linkOsInformation;
        this.language = printerLanguage;
        this.init(zebraPrinter);
    }

    public ZebraPrinterLinkOsImpl(Connection connection, LinkOsInformation linkOsInformation, PrinterLanguage printerLanguage) {
        this.linkOsInformation = linkOsInformation;
        this.language = printerLanguage;
        this.init(new ZebraPrinterZpl(connection));
    }

    private void init(ZebraPrinter zebraPrinter) {
        this.genericPrinter = zebraPrinter;
        this.alerts = new AlertsUtilLinkOs(this);
        this.profile = new ProfileUtilLinkOsImpl(this);
        this.fileUtil = new FileUtilLinkOsImpl(this);
        this.formatUtil = new FormatUtilLinkOsImpl(this);
        this.toolsUtilHelper = new ToolsUtilLinkOsHelper(zebraPrinter.getConnection(), this.language);
        this.fwDownloader = this.getFirmwareDownloader(this);
        this.settings = new ZebraSettingsListFromConnection(zebraPrinter.getConnection());
        this.getCommunityName = "public";
    }

    protected FirmwareUpdaterLinkOs getFirmwareDownloader(ZebraPrinterLinkOs zebraPrinterLinkOs) {
        return new FirmwareUpdaterLinkOsBase(zebraPrinterLinkOs);
    }

    @Override
    public Set<String> getAvailableSettings() throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.getAllSettingIds();
    }

    @Override
    public String getSettingValue(String string) throws SettingsException, ConnectionException, ZebraIllegalArgumentException {
        this.throwExceptionInLinePrintModeRawOnly();
        return this.settings.getValue(string);
    }

    @Override
    public Map<String, String> getSettingsValues(List<String> list) throws SettingsException, ConnectionException, ZebraIllegalArgumentException {
        this.throwExceptionInLinePrintModeRawOnly();
        return this.settings.getValues(list);
    }

    @Override
    public Map<String, String> getAllSettingValues() throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.getAllSettingValues();
    }

    @Override
    public boolean isSettingReadOnly(String string) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.isSettingReadOnly(string);
    }

    @Override
    public boolean isSettingWriteOnly(String string) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.isSettingWriteOnly(string);
    }

    @Override
    public void setSetting(String string, String string2) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        this.settings.setSetting(string, string2);
    }

    @Override
    public void setSettings(Map<String, String> map) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        this.settings.setSettings(map);
    }

    @Override
    public String getSettingRange(String string) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.getSettingRange(string);
    }

    @Override
    public boolean isSettingValid(String string, String string2) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.isSettingValid(string, string2);
    }

    @Override
    public String getSettingType(String string) throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.getSettingType(string);
    }

    @Override
    public void createBackup(String string) throws IOException, ZebraIllegalArgumentException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.profile.createBackup(string);
    }

    @Override
    public void createProfile(String string) throws IOException, ZebraIllegalArgumentException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.profile.createProfile(string);
    }

    @Override
    public void createProfile(OutputStream outputStream) throws IOException, ZebraIllegalArgumentException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.profile.createProfile(outputStream);
    }

    private boolean isOnlySettingsChannelOpen(MultichannelConnection multichannelConnection) {
        return multichannelConnection.getStatusChannel().isConnected() && !multichannelConnection.getPrintingChannel().isConnected();
    }

    @Override
    public void loadProfile(String string) throws IOException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.throwExceptionSupplementalDataStatusOnly(string);
        this.profile.loadProfile(string);
    }

    @Override
    public void loadProfile(String string, FileDeletionOption fileDeletionOption, boolean bl) throws IOException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.throwExceptionSupplementalDataStatusOnly(string);
        this.profile.loadProfile(string, fileDeletionOption, bl);
    }

    @Override
    public void loadBackup(String string) throws IOException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.throwExceptionSupplementalDataStatusOnly(string);
        this.profile.loadBackup(string);
    }

    @Override
    public void loadBackup(String string, boolean bl) throws IOException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.throwExceptionSupplementalDataStatusOnly(string);
        this.profile.loadBackup(string, bl);
    }

    @Override
    public List<PrinterAlert> getConfiguredAlerts() throws ZebraIllegalArgumentException, ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        return this.alerts.getAlerts();
    }

    @Override
    public void configureAlert(PrinterAlert printerAlert) throws ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.configureAlerts(Arrays.asList(printerAlert));
    }

    @Override
    public void configureAlerts(List<PrinterAlert> list) throws ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.alerts.setAlerts(list);
    }

    @Override
    public void removeAlert(PrinterAlert printerAlert) throws ConnectionException {
        if (printerAlert instanceof PrinterAlert) {
            this.configureAlert(new PrinterAlert(printerAlert.getCondition(), printerAlert.getDestination(), false, false, "", 0, false));
        }
    }

    @Override
    public void removeAllAlerts() throws ConnectionException {
        this.throwExceptionInLinePrintModeRawOnly();
        this.alerts.removeAllAlerts();
    }

    @Override
    public PrinterLanguage getPrinterControlLanguage() {
        return this.language;
    }

    @Override
    public PrinterStatus getCurrentStatus() throws ConnectionException {
        PrinterStatus printerStatus = new HostStatusOperation(this.getConnection(), this.getPrinterControlLanguage()).execute();
        return printerStatus;
    }

    @Override
    public List<TcpPortStatus> getPortStatus() throws ConnectionException {
        return PortStatus.getPortStatus(this.genericPrinter.getConnection(), this.getGetCommunityName());
    }

    @Override
    public Connection getConnection() {
        return this.genericPrinter.getConnection();
    }

    @Override
    public void sendFileContents(String string) throws ConnectionException {
        this.genericPrinter.sendFileContents(string);
    }

    @Override
    public String[] retrieveFileNames() throws ConnectionException, ZebraIllegalArgumentException {
        return this.genericPrinter.retrieveFileNames();
    }

    @Override
    public String[] retrieveFileNames(String[] stringArray) throws ConnectionException, ZebraIllegalArgumentException {
        return this.genericPrinter.retrieveFileNames(stringArray);
    }

    @Override
    public void printImage(String string, int n, int n2) throws ConnectionException, IOException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.genericPrinter.printImage(string, n, n2);
    }

    @Override
    public void printImage(String string, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException, IOException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.genericPrinter.printImage(string, n, n2, n3, n4, bl);
    }

    @Override
    public void printImage(ZebraImageI zebraImageI, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.genericPrinter.printImage(zebraImageI, n, n2, n3, n4, bl);
    }

    @Override
    public void storeImage(String string, ZebraImageI zebraImageI, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException {
        new ImageStorer(this.getConnection(), this.getPrinterControlLanguage(), this.getLinkOsInformation()).execute(string, zebraImageI, n, n2);
    }

    @Override
    public void storeImage(String string, String string2, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException, IOException {
        new ImageStorer(this.getConnection(), this.getPrinterControlLanguage(), this.getLinkOsInformation()).execute(string, ReflectionUtil.invokeZebraImageFactory_getImage(string2), n, n2);
    }

    @Override
    public byte[] retrieveFormatFromPrinter(String string) throws ConnectionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.retrieveFormatFromPrinter(byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void retrieveFormatFromPrinter(OutputStream outputStream, String string) throws ConnectionException {
        InputStream inputStream = null;
        HzoToDzConverterStream hzoToDzConverterStream = null;
        StreamDecoratorBase streamDecoratorBase = null;
        try {
            inputStream = new ObjectGrabberOperation(string, this.getConnection(), this.getPrinterControlLanguage(), this.getLinkOsInformation()).execute();
            if (inputStream instanceof MultipartFormReceiverStream) {
                streamDecoratorBase = new MPF_UnwrapperStream(inputStream);
            } else {
                hzoToDzConverterStream = new HzoToDzConverterStream(inputStream);
                streamDecoratorBase = new DZ_UnwrapperStream(hzoToDzConverterStream);
            }
            outputStream.write(ZPLUtilities.replaceAllWithInternalCharacters("^XA").getBytes());
            int n = streamDecoratorBase.read();
            while (n != -1) {
                outputStream.write(n);
                n = streamDecoratorBase.read();
            }
            outputStream.write(ZPLUtilities.replaceAllWithInternalCharacters("^XZ").getBytes());
        }
        catch (IOException iOException) {
            try {
                throw new ConnectionException(iOException.getLocalizedMessage());
                catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                    throw new ConnectionException(zebraIllegalArgumentException.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(hzoToDzConverterStream);
                IOUtils.closeQuietly(streamDecoratorBase);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(hzoToDzConverterStream);
        IOUtils.closeQuietly(streamDecoratorBase);
    }

    @Override
    public void printStoredFormat(String string, String[] stringArray) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.genericPrinter.printStoredFormat(string, stringArray);
    }

    @Override
    public void printStoredFormat(String string, String[] stringArray, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.throwExceptionInLinePrintMode();
        this.genericPrinter.printStoredFormat(string, stringArray, string2);
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.genericPrinter.printStoredFormat(string, map);
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.throwExceptionInLinePrintMode();
        this.genericPrinter.printStoredFormat(string, map, string2);
    }

    @Override
    public FieldDescriptionData[] getVariableFields(String string) {
        return this.genericPrinter.getVariableFields(string);
    }

    @Override
    public void printStoredFormatWithVarGraphics(String string, Map<Integer, String> map) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.formatUtil.printStoredFormatWithVarGraphics(string, map);
    }

    @Override
    public void printStoredFormatWithVarGraphics(String string, Map<Integer, String> map, String string2) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.formatUtil.printStoredFormatWithVarGraphics(string, map, string2);
    }

    @Override
    public void printStoredFormatWithVarGraphics(String string, Map<Integer, ZebraImageI> map, Map<Integer, String> map2) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.formatUtil.printStoredFormatWithVarGraphics(string, map, map2);
    }

    @Override
    public void printStoredFormatWithVarGraphics(String string, Map<Integer, ZebraImageI> map, Map<Integer, String> map2, String string2) throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.throwExceptionStatusOnly();
        this.formatUtil.printStoredFormatWithVarGraphics(string, map, map2, string2);
    }

    @Override
    public void calibrate() throws ConnectionException {
        new PrinterCalibrator(this.getConnection(), this.getPrinterControlLanguage()).execute();
    }

    @Override
    public void restoreNetworkDefaults() throws ConnectionException {
        new NetworkDefaulter(this.getConnection(), this.getPrinterControlLanguage()).execute();
    }

    @Override
    public void restoreDefaults() throws ConnectionException {
        new PrinterDefaulter(this.getConnection(), this.getPrinterControlLanguage()).execute();
    }

    @Override
    public LinkOsInformation getLinkOsInformation() {
        return this.linkOsInformation;
    }

    @Override
    public void printConfigurationLabel() throws ConnectionException {
        new ConfigurationLabelPrinter(this.getConnection(), this.getPrinterControlLanguage(), this.linkOsInformation).execute();
    }

    @Override
    public void printNetworkConfigurationLabel() throws ConnectionException {
        new NetworkConfigurationLabelPrinter(this.getConnection(), this.getPrinterControlLanguage(), this.linkOsInformation).execute();
    }

    @Override
    public void printDirectoryLabel() throws ConnectionException {
        this.throwExceptionInLinePrintMode();
        this.toolsUtilHelper.printDirectoryLabel();
    }

    @Override
    public void sendCommand(String string) throws ConnectionException {
        this.genericPrinter.sendCommand(string);
    }

    @Override
    public void sendCommand(String string, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.genericPrinter.sendCommand(string, string2);
    }

    @Override
    public void reset() throws ConnectionException {
        new PrinterResetter(this.getConnection(), this.getPrinterControlLanguage()).execute();
    }

    @Override
    public void resetNetwork() throws ConnectionException {
        new NetworkResetter(this.getConnection(), this.getPrinterControlLanguage()).execute();
    }

    @Override
    public void setClock(String string) throws ConnectionException, ZebraIllegalArgumentException {
        this.toolsUtilHelper.setClock(string);
    }

    @Override
    public void downloadTtfFont(String string, String string2) throws ConnectionException {
        this.downloadFont(string, FileUtilities.changeExtension(string2, ".TTF"));
    }

    @Override
    public void downloadTtfFont(InputStream inputStream, String string) throws ConnectionException {
        this.downloadFont(inputStream, FileUtilities.changeExtension(string, ".TTF"));
    }

    @Override
    public void downloadTteFont(String string, String string2) throws ConnectionException {
        this.downloadFont(string, FileUtilities.changeExtension(string2, ".TTE"));
    }

    @Override
    public void downloadTteFont(InputStream inputStream, String string) throws ConnectionException {
        this.downloadFont(inputStream, FileUtilities.changeExtension(string, ".TTE"));
    }

    private void downloadFont(String string, String string2) throws ConnectionException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.downloadFont(fileInputStream, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConnectionException(fileNotFoundException.getLocalizedMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void downloadFont(InputStream inputStream, String string) throws ConnectionException {
        try {
            ArrayList<PrinterFileDescriptor> arrayList = new ArrayList<PrinterFileDescriptor>();
            if (inputStream instanceof FileInputStream) {
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(fileChannel.size(), "0000", "0000");
                arrayList.add(new PrinterFileDescriptor(inputStream, string, printerFileMetadata));
                FileStorer fileStorer = new FileStorer(arrayList, this.getConnection(), this.getPrinterControlLanguage(), this.linkOsInformation);
                fileStorer.execute();
                fileChannel.close();
            } else if (inputStream.markSupported()) {
                inputStream.mark(Integer.MAX_VALUE);
                PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(inputStream);
                inputStream.reset();
                arrayList.add(new PrinterFileDescriptor(inputStream, string, printerFileMetadata));
                FileStorer fileStorer = new FileStorer(arrayList, this.getConnection(), this.getPrinterControlLanguage(), this.linkOsInformation);
                fileStorer.execute();
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (inputStream.available() > 0) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                arrayList.add(new PrinterFileDescriptor(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string, printerFileMetadata));
                FileStorer fileStorer = new FileStorer(arrayList, this.getConnection(), this.getPrinterControlLanguage(), this.linkOsInformation);
                fileStorer.execute();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConnectionException(fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public List<StorageInfo> getStorageInfo() throws ConnectionException {
        return this.fileUtil.getStorageInfo();
    }

    @Override
    public void storeFileOnPrinter(String string) throws ConnectionException, IOException, ZebraIllegalArgumentException {
        this.fileUtil.storeFileOnPrinter(string);
    }

    @Override
    public void storeFileOnPrinter(String string, String string2) throws ConnectionException, IOException, ZebraIllegalArgumentException {
        this.fileUtil.storeFileOnPrinter(string, string2);
    }

    @Override
    public void storeFileOnPrinter(byte[] byArray, String string) throws ConnectionException, ZebraIllegalArgumentException {
        this.fileUtil.storeFileOnPrinter(byArray, string);
    }

    @Override
    public void deleteFile(String string) throws ConnectionException {
        this.fileUtil.deleteFile(string);
    }

    @Override
    public byte[] getPrinterDownloadableObjectFromPrinter(String string) throws ConnectionException, ZebraIllegalArgumentException {
        return this.fileUtil.getPrinterDownloadableObjectFromPrinter(string);
    }

    @Override
    public byte[] getObjectFromPrinter(String string) throws ConnectionException, ZebraIllegalArgumentException {
        return this.fileUtil.getObjectFromPrinter(string);
    }

    @Override
    public void getObjectFromPrinter(OutputStream outputStream, String string) throws ConnectionException, ZebraIllegalArgumentException {
        this.fileUtil.getObjectFromPrinter(outputStream, string);
    }

    @Override
    public byte[] getObjectFromPrinterViaFtp(String string, String string2) throws ConnectionException, ZebraIllegalArgumentException {
        return this.fileUtil.getObjectFromPrinterViaFtp(string, string2);
    }

    @Override
    public void getObjectFromPrinterViaFtp(OutputStream outputStream, String string, String string2) throws ConnectionException, ZebraIllegalArgumentException {
        this.fileUtil.getObjectFromPrinterViaFtp(outputStream, string, string2);
    }

    @Override
    public void sendFileContents(String string, ProgressMonitor progressMonitor) throws ConnectionException {
        this.genericPrinter.sendFileContents(string, progressMonitor);
    }

    @Override
    public void updateFirmware(String string, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.fwDownloader.updateFirmware(string, firmwareUpdateHandler);
    }

    @Override
    public void updateFirmware(String string, long l, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.fwDownloader.updateFirmware(string, l, firmwareUpdateHandler);
    }

    @Override
    public void updateFirmwareUnconditionally(String string, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.fwDownloader.updateFirmwareUnconditionally(string, firmwareUpdateHandler);
    }

    @Override
    public void updateFirmwareUnconditionally(String string, long l, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.fwDownloader.updateFirmwareUnconditionally(string, l, firmwareUpdateHandler);
    }

    @Override
    public String getGetCommunityName() {
        return this.getCommunityName;
    }

    @Override
    public void setGetCommunityName(String string) {
        this.getCommunityName = string;
    }

    @Override
    public void setConnection(Connection connection) {
        this.genericPrinter.setConnection(connection);
        this.settings.setConnection(connection);
    }

    @Override
    public List<PrinterObjectProperties> retrieveObjectsProperties() throws ConnectionException, ZebraIllegalArgumentException {
        return new ObjectsListingOperation(this.getConnection(), this.getPrinterControlLanguage(), this.linkOsInformation).execute();
    }

    @Override
    public Map<String, Setting> getAllSettings() throws SettingsException {
        try {
            this.throwExceptionInLinePrintModeRawOnly();
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return this.settings.getAllSettings();
    }

    @Override
    public Map<String, String> processSettingsViaMap(Map<String, String> map) throws SettingsException, ConnectionException {
        SettingsUpdaterOperation settingsUpdaterOperation = new SettingsUpdaterOperation(this.getConnection(), map, this.getPrinterControlLanguage());
        return settingsUpdaterOperation.process();
    }

    private void throwExceptionInLinePrintMode() throws ConnectionException {
        if (this.getPrinterControlLanguage() == PrinterLanguage.LINE_PRINT) {
            throw new ConnectionException("Operation cannot be performed with a printer set to line print mode");
        }
    }

    private void throwExceptionInLinePrintModeRawOnly() throws ConnectionException {
        MultichannelConnection multichannelConnection;
        Connection connection = this.getConnection();
        if (this.getPrinterControlLanguage() == PrinterLanguage.LINE_PRINT && (connection instanceof MultichannelConnection ? (multichannelConnection = (MultichannelConnection)connection).getPrintingChannel().isConnected() && !multichannelConnection.getStatusChannel().isConnected() : !(connection instanceof StatusConnection))) {
            throw new ConnectionException("Operation cannot be performed on raw channel with a printer set to line print mode");
        }
    }

    private void throwExceptionSupplementalDataStatusOnly(String string) throws FileNotFoundException, IOException, ConnectionException {
        if (this.hasSupplementalData(string)) {
            Connection connection = this.getConnection();
            if (connection instanceof MultichannelConnection) {
                MultichannelConnection multichannelConnection = (MultichannelConnection)connection;
                if (this.isOnlySettingsChannelOpen(multichannelConnection)) {
                    throw new ConnectionException("Supplemental data cannot be sent with only the status channel open");
                }
            } else if (connection instanceof StatusConnection) {
                throw new ConnectionException("Supplemental data cannot be sent over the status channel");
            }
        }
    }

    private void throwExceptionStatusOnly() throws ConnectionException {
        Connection connection = this.getConnection();
        if (connection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)connection;
            if (this.isOnlySettingsChannelOpen(multichannelConnection)) {
                throw new ConnectionException("Operation cannot be performed with only the status channel open");
            }
        } else if (connection instanceof StatusConnection) {
            throw new ConnectionException("Operation cannot be performed over the status channel");
        }
    }

    private boolean hasSupplementalData(String string) throws FileNotFoundException, IOException {
        return new ZipUtil(string).extractEntry("profileSupplement.txt").length > 0;
    }
}

