/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.graphics.internal.Ditherer;
import com.zebra.sdk.graphics.internal.DitheringStream;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.FileStorer;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.PrinterFilePath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ImageStorer {
    private Connection connection;
    private PrinterLanguage language;
    private LinkOsInformation linkOsInformation;

    public ImageStorer(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        this.connection = connection;
        this.language = printerLanguage;
        this.linkOsInformation = linkOsInformation;
    }

    public void execute(String string, ZebraImageI zebraImageI, int n, int n2) throws ZebraIllegalArgumentException, ConnectionException {
        ZebraImageInternal zebraImageInternal = (ZebraImageInternal)zebraImageI;
        if (zebraImageInternal == null) {
            throw new ZebraIllegalArgumentException("Invalid image file.");
        }
        zebraImageInternal.scaleImage(n, n2);
        try {
            ArrayList<PrinterFileDescriptor> arrayList;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
            String string2 = ImageStorer.getCorrectedFileName(printerFilePath);
            if (printerFilePath.getExtension() != null && printerFilePath.getExtension().equalsIgnoreCase(".PNG")) {
                for (ArrayList arrayList2 : arrayList = (ArrayList<PrinterFileDescriptor>)Ditherer.getZebraSpecificPngHeader(n, n2)) {
                    byteArrayOutputStream.write((int)arrayList2);
                }
                zebraImageInternal.writeDitheredPng(byteArrayOutputStream);
            } else {
                arrayList = new DitheringStream(zebraImageInternal);
                IOUtils.copy((InputStream)((Object)arrayList), (OutputStream)byteArrayOutputStream);
                ((InputStream)((Object)arrayList)).close();
                byteArrayOutputStream.close();
            }
            arrayList = new ArrayList<PrinterFileDescriptor>();
            PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            arrayList.add(new PrinterFileDescriptor(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string2, printerFileMetadata));
            FileStorer fileStorer = new FileStorer(arrayList, this.connection, this.language, this.linkOsInformation);
            fileStorer.execute();
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    private static String getCorrectedFileName(PrinterFilePath printerFilePath) throws ZebraIllegalArgumentException {
        String string = printerFilePath.getDrive();
        String string2 = printerFilePath.getFileName();
        String string3 = printerFilePath.getExtension();
        if (string3 == null || !string3.equalsIgnoreCase(".PNG")) {
            string3 = ".GRF";
        }
        if (string == null || string.length() == 0) {
            string = "E";
        } else if (string.length() > 1) {
            throw new ZebraIllegalArgumentException("Invalid drive specified : " + string);
        }
        return string + ":" + string2 + string3;
    }
}

