/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.internal.ToolsUtilLinkOsHelper;
import com.zebra.sdk.printer.operations.internal.PrinterOperationCaresAboutLinkOsVersion;

public class NetworkConfigurationLabelPrinter
extends PrinterOperationCaresAboutLinkOsVersion<Void> {
    private static final long serialVersionUID = -232786459659968863L;

    public NetworkConfigurationLabelPrinter(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        super(connection, printerLanguage, linkOsInformation);
    }

    @Override
    public Void execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        this.printNetworkConfigLabel();
        return null;
    }

    private void isOkToProceed() throws ConnectionException {
        if (!(this.isLinkOs2_5_OrHigher() || !(this.connection instanceof StatusConnection) && this.connection.isConnected())) {
            throw new ConnectionException("Cannot print network config label over status channel on this version of firmware");
        }
    }

    private void printNetworkConfigLabel() throws ConnectionException {
        if (this.isLinkOs2_5_OrHigher()) {
            if (this.isPrintingChannelInLineMode()) {
                this.connection.write("! U1 setvar \"device.print_out_report\" \"network\"\r\n".getBytes());
            } else {
                new PrinterCommandImpl("{}{\"device.print_out_report\":\"network\"}").sendAndWaitForValidJsonResponse(this.connection);
            }
        } else {
            new ToolsUtilLinkOsHelper(this.connection, this.printerLanguage).printNetworkConfigurationLabel();
        }
    }
}

