/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;

class AsnDecoderBase {
    private static final String version_id = "@(#)$Id: AsnDecoderBase.java,v 3.3 2007/10/17 10:36:47 birgita Exp $ Copyright Westhawk Ltd";

    AsnDecoderBase() {
    }

    AsnSequence getAsnSequence(InputStream in) throws IOException, DecodingException {
        AsnSequence asnTopSeq = null;
        AsnSequence dummy = new AsnSequence();
        AsnObject obj = dummy.AsnReadHeader(in);
        if (!(obj instanceof AsnSequence)) {
            String msg = "AsnSequence was expected";
            msg = obj != null ? msg + " instead of " + obj.getRespTypeString() : msg + ", but is null";
            throw new DecodingException(msg);
        }
        asnTopSeq = (AsnSequence)obj;
        return asnTopSeq;
    }

    int getSNMPVersion(AsnSequence asnTopSeq) throws DecodingException {
        int version = -1;
        AsnObject obj = asnTopSeq.getObj(0);
        if (!(obj instanceof AsnInteger)) {
            String msg = "SNMP version should be of type AsnInteger instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnInteger v = (AsnInteger)obj;
        version = v.getValue();
        return version;
    }

    String getCommunity(AsnSequence asnTopSeq) throws DecodingException {
        String comm = "";
        AsnObject obj = asnTopSeq.getObj(1);
        if (!(obj instanceof AsnOctets)) {
            String msg = "community should be of type AsnOctets instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnOctets estat = (AsnOctets)obj;
        comm = estat.getValue();
        return comm;
    }

    AsnSequence getAsnHeaderData(AsnSequence asnTopSeq) throws DecodingException {
        AsnSequence asnHeaderData = null;
        AsnObject obj = asnTopSeq.getObj(1);
        if (!(obj instanceof AsnSequence)) {
            String msg = "asnHeaderData should be of type AsnSequence instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        asnHeaderData = (AsnSequence)obj;
        return asnHeaderData;
    }
}

